<?php

new STM_LMS_Compatibility();

class STM_LMS_Compatibility {

	private static $theme = '4.4.6';

	public function __construct() {

		add_action( 'admin_notices', array( $this, 'init' ) );

	}

	public function check_version() {
// phpcs:ignore Squiz.PHP.CommentedOutCode.Found
		//		$has_pro = defined('STM_LMS_PRO_FILE');
		//		if(!$has_pro) return false;
		//		$plugin_data = get_plugin_data( STM_LMS_PRO_FILE );
		//		$version = $plugin_data['Version'];
		$theme = wp_get_theme();
		if ( 'MasterStudy' == $theme->name ) {
			return version_compare( self::$theme, $theme->version ) > 0;
		}
	}

	public function init() {

		if ( $this->check_version() ) : ?>

			<div class="notice notice-lms notice-lms-go-to-pages notice-lms-compatibility">

				<div class="notice-lms-go-to-pages-icon">
					<i class="fa fa-exclamation"></i>
				</div>

				<div class="notice-lms-go-to-pages-content">

					<p>
						<strong>
							<?php esc_html_e( 'Please update MasterStudy Theme!', 'masterstudy-lms-learning-management-system' ); ?>
						</strong>
					</p>

					<p>
						<?php esc_html_e( 'The current version of MasterStudy LMS is not compatible with old versions of the MasterStudy Theme, some functionality may not work correctly or may stop working completely.', 'masterstudy-lms-learning-management-system' ); ?>
					</p>

				</div>

			</div>

			<?php
		endif;

	}

}
