<?php

namespace StmLmsElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if( !defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Hello World
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class StmLmsCourseBundles extends Widget_Base
{

    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'stm_lms_course_bundles';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __( 'Course Bundles', 'masterstudy-lms-learning-management-system' );
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'eicon-price-list lms-icon';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return [ 'theme-elements' ];
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'section_content',
            [
                'label' => __( 'Content', 'masterstudy-lms-learning-management-system' ),
            ]
        );
        $this->add_control(
            'title',
            [
                'name' => 'title',
                'label' => __( 'Title', 'masterstudy-lms-learning-management-system' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

		$this->add_control(
			'bundles',
			array(
				'name'        => 'bundles',
				'label'       => __( 'Select bundles', 'masterstudy-lms-learning-management-system' ),
				'type'        => \Elementor\Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple'    => true,
				'options'     => stm_lms_elementor_autocomplete_bundles(),
			)
		);

        $this->add_control(
            'columns',
            [
                'name' => 'columns',
                'label' => __( 'Columns', 'masterstudy-lms-learning-management-system' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'label_block' => true,
                'options' => array(
                    '2' => '2',
                    '3' => '3',
                ),
                'default' => '3'
            ]
        );

        $this->add_control(
            'posts_per_page',
            [
                'name' => 'posts_per_page',
                'label' => __( 'Posts per page', 'masterstudy-lms-learning-management-system' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

    }

    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$atts = array(
			"css"            => '',
			"title"          => !empty( $settings['title'] ) ? $settings['title'] : '',
			"columns"        => !empty( $settings['columns'] ) ? $settings['columns'] : '3',
			"posts_per_page" => !empty( $settings['posts_per_page'] ) ? $settings['posts_per_page'] : '3',
			"wishlist"       => !empty( $settings['bundles'] ) ? $settings['bundles'] : '',
		);
		if ( class_exists( 'STM_LMS_Course_Bundle' ) ) {
			\STM_LMS_Templates::show_lms_template( 'vc_templates/templates/stm_lms_course_bundles', $atts );
		}
	}

    /**
     * Render the widget output in the editor.
     *
     * Written as a Backbone JavaScript template and used to generate the live preview.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function content_template()
    {

    }
}



